﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" 
    CodeFile="ReportUniqueIndividuals.aspx.cs" Inherits="ReportUniqueIndividuals" 
    MaintainScrollPositionOnPostback="true" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

        <script type="text/javascript">
            // Remove all Export options except PDF
            function ContentPageOnLoad() {
                var batchReport = '<%=SessionItemValue.Get(Session["batchReport"])%>';

            var formatDropDown = document.getElementById('ctl00_ContentPlaceHolder_ReportViewerReport_ctl01_ctl05_ctl00');
            if (formatDropDown != null && batchReport.toLowerCase() == 'true') {
                var EFRBatchPrintOptions = '<%=SessionItemValue.Get(Session["EFRBatchPrintOptions"])%>';
                var options = EFRBatchPrintOptions.split(";");
                var found = "false";
                var i;

                for (i = formatDropDown.options.length - 1; i >= 0; i--) {
                    if (formatDropDown[i].value != null && formatDropDown[i].value != "Select a format") {
                        found = "false";

                        for (var j = 0; j < options.length; j++) {
                            if (formatDropDown[i].value == options[j]) {
                                found = "true";
                                break;
                            }
                        }

                        if (found == "false") {
                            formatDropDown.remove(i);
                        }
                    }
                }
            } else if (formatDropDown != null && batchReport.toLowerCase() == 'false') {
                var EFRBatchPrintOptions = '<%=SessionItemValue.Get(Session["EFRIndividualPrintOptions"])%>';
                var options = EFRBatchPrintOptions.split(";");
                var found = "false";
                var i;
                for (i = formatDropDown.options.length - 1; i >= 0; i--) {
                    if (formatDropDown[i].value != null && formatDropDown[i].value != "Select a format") {
                        found = "false";

                        for (var j = 0; j < options.length; j++) {
                            if (formatDropDown[i].value == options[j]) {
                                found = "true";
                                break;
                            }
                        }

                        if (found == "false") {
                            formatDropDown.remove(i);
                        }
                    }
                }
            }
    }
</script>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Reporting > DoD Fragment Report"/>
    </div> 
    
    <br />
   <div class = "excludeSaveWarnings">
    
    <asp:GridView ID = "GridViewUniqueIndividualsFiles" runat = "server" 
        AutoGenerateColumns = "false" CaptionAlign="Top"
        AllowPaging="True" PageSize="20" DataKeyNames = "Id" 
        AllowSorting="false" 
        onpageindexchanging="UniqueIndividuals_PageIndexChanging" 
        onselectedindexchanging="UniqueIndividuals_SelectedIndexChanging" 
        >
       <EmptyDataTemplate>
            No Records files exist 
       </EmptyDataTemplate> 
        
        <Columns>       
           
            <asp:BoundField datafield="Created" dataformatstring="{0:MM/dd/yyyy}"  HeaderText = "Date"/>  

            <asp:TemplateField HeaderText = "Embedded Fragments Present" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "EmbFragPresentCount" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("EmbFragPresentCount","{0:0,0}")), false) %>' ></asp:Label>                 
                </ItemTemplate> 
            </asp:TemplateField>    
                             
            <asp:TemplateField HeaderText="Total Screened" >                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="NoFragPresentCount" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NoFragPresentCount","{0:0,0}")), false) %>'  ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="CreatedBy">                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="CreatedBy" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CreatedBy")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField> 
                        
        </Columns>
    </asp:GridView>          
</asp:Content>









